#This script first creates a text file (files_to_download.txt) that lists all the database files to download from the NCBI server (ftp://ftp.ncbi.nlm.nih.gov/blast/db/), then asks the user if the list is correct (y/n), in which case it downloads the listed files into the current directory. If the answer is negative, the process is interrupted.
#To execute this script type the database name prefix as a parameter, for example nt or nr.
#Example1: bash download_db.sh nt
#Example2: bash download_db.sh nr
curl -l ftp://ftp.ncbi.nlm.nih.gov/blast/db/ | grep "^$1" > files_to_download.txt
echo -n "Are all the desired files listed in files_to_download.txt? (y/n): "
read answer
case $answer in
[Yy]*)
file_list=`cat files_to_download.txt`
for i in $file_list
	do
		wget -c --retry-connrefused --tries=0 --timeout=5 ftp://ftp.ncbi.nlm.nih.gov/blast/db/$i
	done
;;
[Nn]*)
exit 1
;;
esac

